﻿//////////////////////////////////////////////
// MeshUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class LogManager ;
	class Mesh ;

	struct DecodedMeshData ;
	struct VertexComposition ;
	struct VertexData ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../../Bounds/BoundingBox.h"

#include "../../Dll/DllDefines.h"

#include "../InputLayouts/MeshInputLayoutAttribute.h"

#include "MeshFillOptions.h"
#include "AttributeGenerationInfo.h"
#include "AttributeGenerationOutput.h"
#include "PackedMeshData.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT MeshUtils final
	{
		public :

			// Translation
			static PackedMeshData packIntoMeshData (const nkMemory::BufferView<VertexData>& meshInfo, const VertexComposition& composition) ;

			// Filling
			static void fillMeshFromDecodedData (DecodedMeshData& data, Mesh* mesh, const MeshFillOptions& options = MeshFillOptions()) ;

			// Computing
			static BoundingBox computeBounds (const nkMemory::BufferView<unsigned char>& vertexBuffer, unsigned int byteStride, const MeshInputLayoutAttribute& positionAttribute, LogManager* logManager) ;
			static AttributeGenerationOutput computeNormals (const AttributeGenerationInfo& inputInfo, LogManager* logManager) ;
			static void computeNormals (const AttributeGenerationInfo& inputInfo, AttributeGenerationOutput& outputInfo, LogManager* logManager) ;
			static AttributeGenerationOutput computeBinormals (const AttributeGenerationInfo& inputInfo, LogManager* logManager) ;
			static void computeBinormals (const AttributeGenerationInfo& inputInfo, AttributeGenerationOutput& outputInfo, LogManager* logManager) ;
			static AttributeGenerationOutput computeTangents (const AttributeGenerationInfo& inputInfo, LogManager* logManager) ;
			static void computeTangents (const AttributeGenerationInfo& inputInfo, AttributeGenerationOutput& outputInfo, LogManager* logManager) ;
	} ;
}